/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file    DM8127_EVM.h
 *
 * \brief   Defines the SoC specific memory Maps
 *
 * This header file contains the Macros definitions for SoC memory maps
 * 
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created.
 * \version 02a,12Aug,An, 2016 comments and codeupdated for the 
 *                             processor DM8127.
 */

#ifndef _DM8127_EVM_H_
#define _DM8127_EVM_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Defines
 *====================
*/

//#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
//#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)
/*
 *====================
 * Includes
 *====================
 */
#include "DM8127_types.h"
#include "Dm8127_Platform.h"
//#include "version.h"

/**
@addtogroup DM8127 EVM
@{
*/

/*
 *====================
 * Defines
 *====================
*/

/*
 *====================
 * Function declaration
 *====================
*/

/** **************************************************************************
 * \n \brief Micro-second delay routine
 *
 * Utility routine for micro-seconds
 * 
 * \param  u32usec	[IN] 	Delay in micro-seconds
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
extern void DM8127_usecDelay 
( 
	UINT32 u32usec 
);

/***
 * \brief: Routine to initialize the DM8127 EVM board
 *
 * \b Descr: This routine initializes the DM8127 EVM Base Board
 *
 * \param:  VOID
 * \return: SUCCESS for success  - Description
 *          FAILED for error   - Description
 *
 */
STATUS DM8127_EVM_Init
(
	void
);

/***
 * \brief: delay routine.
 *
 * \param: delay_count [IN]  number of delay count.
 *
 * \return: VOID
 */
void delay
(
	SINT32 delay_count
);

extern void DM8127_wait(UINT32 u32Delay );
//
//SINT32 detect_card
//(
//	SDIO_controllerReg *SDIO_BASE,
//	SINT32 *is_high_cap
//);
/* @} */   /* End of EVM */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM8127_EVM_H_ */
